///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CStatusDlg_CPP
#define _CStatusDlg_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#ifdef _SQLESERVER
	#include "../../SQLEServer/Resources/Resource.H"
	#include "../../SQLEServer/Source/Entry.H"
#elif _SQLECLIENT
	#include "../../SQLEClient/Resources/Resource.H"
	#include "../../SQLEClient/Source/Entry.H"
#else
	#error "You must define either _SQLESERVER or _SQLECLIENT"
#endif

#include "../../SharedSource/NSWFL.H"
#include "CStatusDlg.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CStatusDlg::CStatusDlg()
{
	hEvent = NULL;
	hDialogHandle = NULL;
	hOwnerHandle = NULL;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

CStatusDlg::~CStatusDlg()
{
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI CStatusDlg_Thread(LPVOID lpData)
{
	CStatusDlg *lpDlg = ((CStatusDlg *) lpData);
	
    MSG MyMsg;

	memset(&MyMsg, 0, sizeof(MyMsg));

	lpDlg->hDialogHandle = CreateDialog(
		ghAppInstance,
		MAKEINTRESOURCE(IDD_STATUSDLG),
		lpDlg->hOwnerHandle,
		(DLGPROC)CStatusDlgProc
	);

	SetEvent(lpDlg->hEvent);

	if(lpDlg->hDialogHandle == NULL)
	{
		MessageBox(NULL, "Failed to load the status dialog box.", gsTitleCaption, MB_TASKMODAL | MB_ICONERROR);
		return 0;
	}

	while(GetMessage(&MyMsg, lpDlg->hDialogHandle, 0, 0) > 0)
    {
        TranslateMessage(&MyMsg);
        DispatchMessage(&MyMsg);
    }

	SendMessage(lpDlg->hDialogHandle,  WM_QUIT, 0, 0);

	lpDlg->hDialogHandle = NULL;

	return 0;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::SetButtonText(char *sText)
{
	Set_Text(hCmdCancel, sText);
	return true;
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::EnableButton(void)
{
	EnableWindow(hCmdCancel, true);
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::DisableButton(void)
{
	EnableWindow(hCmdCancel, false);
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::SetProgressPos(long lPos)
{
	SendMessage(hProgress, (UINT) PBM_SETPOS, lPos, 0);
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::SetProgressRange(long lMin, long lMax)
{
	SendMessage(hProgress, (UINT) PBM_SETRANGE, 0, MAKELPARAM(lMin, lMax));
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::SetText(char *sText)
{
	Set_Text(hText, sText);
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::Unload(void)
{
	if(hDialogHandle)
	{
		SendMessage(hDialogHandle, WM_COMMAND, IDC_CANCEL, NULL);
	}

	while(IsWindow(hDialogHandle))
	{
		Sleep(1);
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

HWND CStatusDlg::Load(HWND hOwner, char *sTitle, int iIcon, bool bAllowCancel)
{
	hOwnerHandle = hOwner;
	
	hEvent = CreateEvent(NULL, TRUE, FALSE, "CStatusDlg_Thread_Function");

	CStatusDlg_Thread_Handle = CreateThread(NULL, 0, CStatusDlg_Thread, (LPVOID)this, 0, &CStatusDlg_Thread_ID);

    if(WaitForSingleObject(hEvent, 5000) == WAIT_TIMEOUT)
    {
        CloseHandle(hEvent);
        return NULL;
    }

    SendMessage(hDialogHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sTitle);
    SendMessage(hDialogHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(iIcon)));

	hText      = GetDlgItem(hDialogHandle, IDC_STATTEXT);
	hProgress  = GetDlgItem(hDialogHandle, IDC_STATPROGRESS);
	hCmdCancel = GetDlgItem(hDialogHandle, IDC_CANCEL);

	if(!bAllowCancel)
	{
		EnableWindow(hCmdCancel, false);
	}

	CloseHandle(hEvent);

	return hDialogHandle;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::SetIcon(int iIcon)
{
	SendMessage(hDialogHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(iIcon)));
	return true;
}


///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::SetCaption(char *sCaption)
{
	SendMessage(hDialogHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::Show(void)
{
	ShowWindow(hDialogHandle, SW_SHOW);

	SetForegroundWindow(hDialogHandle);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::IsDlg(void)
{
	return IsWindow(hDialogHandle) == TRUE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::IsDlgVisible(void)
{
	if(IsWindowVisible(hDialogHandle))
	{
		return true;
	}
	return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CStatusDlg::Hide(void)
{
	if(ShowWindow(hDialogHandle, SW_HIDE))
	{
		return true;
	}
	return false;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK CStatusDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    if(uMsg == WM_INITDIALOG)
    {
		CenterWindow(hWnd);
        return TRUE;
    }

    if(uMsg == WM_COMMAND)
    {
		if(wParam == IDC_CANCEL)
		{
			PostMessage(hWnd, WM_QUIT, 0, 0);
			return TRUE;
		}

		return FALSE;
    }

	if(uMsg == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(hWnd, &ThisPS);

        // Any painting should be done here

        EndPaint(hWnd, &ThisPS);
        return TRUE;
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

